---
title: Account-level DNS analytics now available via GraphQL Analytics API · Changelog
description: Authoritative DNS analytics can now be accessed on the account
  level via the GraphQL Analytics API.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-23-account-level-dns-analytics-api/
  md: https://developers.cloudflare.com/changelog/2025-06-23-account-level-dns-analytics-api/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Account-level DNS analytics now available via GraphQL Analytics API

Jun 19, 2025

[DNS](https://developers.cloudflare.com/dns/)

Authoritative DNS analytics are now available on the **account level** via the [Cloudflare GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/).

This allows users to query DNS analytics across multiple zones in their account, by using the `accounts` filter.

Here is an example to retrieve the most recent DNS queries across all zones in your account that resulted in an `NXDOMAIN` response over a given time frame. Please replace `a30f822fcd7c401984bf85d8f2a5111c` with your actual account ID.

```graphql
query GetLatestNXDOMAINResponses {
  viewer {
    accounts(filter: { accountTag: "a30f822fcd7c401984bf85d8f2a5111c" }) {
      dnsAnalyticsAdaptive(
        filter: {
          date_geq: "2025-06-16"
          date_leq: "2025-06-18"
          responseCode: "NXDOMAIN"
        }
        limit: 10000
        orderBy: [datetime_DESC]
      ) {
        zoneTag
        queryName
        responseCode
        queryType
        datetime
      }
    }
  }
}
```

[Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBA4mALgGQIaLAZ0QOQBoAiA8gLICCAkjgEpYAOA9gHaZYwDeAUDDAG4CWYAO6QO3HjFQBjKQxBNEmABQAzfgBsMEAFwdJMuQoAqqAOa6ARKgDMABhUAOAExOVUgCYB2KQBZbARgBOBx8AI0cAVncHFSdUCP9EqQsYAF8ASjEJCXcWMiZUdShEfilMMndUOhLeMCVxbJ41TUhdLkbGyowAfVMwYEsnWycIgFpbADZR-wmLBo6YLrBu9X7B4bHJ6Yc5hYkIemZWAGEGdzBLfGJyKl2F1Pns9X4AW35EXX9bb9tHiQYIOcIAAhKC6ADaSxKL2WBAAogBlY4AXT+mXaCwAXswwCZTH8eKBIFAcKgYQSYAdMIwWGBTucKUToEYoHQwBSoa92R0HtleWlOKkgA\&variables=N4XyA)

To learn more and get started, refer to the [DNS Analytics documentation](https://developers.cloudflare.com/dns/additional-options/analytics/#analytics).
