---
title: Automatic loopback bindings via ctx.exports · Changelog
description: You no longer have to configure bindings explicitly when they point
  back to your own Worker's top-level exports
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-26-ctx-exports/
  md: https://developers.cloudflare.com/changelog/2025-09-26-ctx-exports/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Automatic loopback bindings via ctx.exports

Sep 26, 2025

[Workers](https://developers.cloudflare.com/workers/)

The [`ctx.exports` API](https://developers.cloudflare.com/workers/runtime-apis/context/#exports) contains automatically-configured bindings corresponding to your Worker's top-level exports. For each top-level export extending `WorkerEntrypoint`, `ctx.exports` will contain a [Service Binding](https://developers.cloudflare.com/workers/runtime-apis/bindings/service-bindings) by the same name, and for each export extending `DurableObject` (and for which storage has been configured via a [migration](https://developers.cloudflare.com/durable-objects/reference/durable-objects-migrations/)), `ctx.exports` will contain a [Durable Object namespace binding](https://developers.cloudflare.com/durable-objects/api/namespace/). This means you no longer have to configure these bindings explicitly in `wrangler.jsonc`/`wrangler.toml`.

Example:

```js
import { WorkerEntrypoint } from "cloudflare:workers";


export class Greeter extends WorkerEntrypoint {
  greet(name) {
    return `Hello, ${name}!`;
  }
}


export default {
  async fetch(request, env, ctx) {
    let greeting = await ctx.exports.Greeter.greet("World")
    return new Response(greeting);
  }
}
```

At present, you must use [the `enable_ctx_exports` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags#enable-ctxexports) to enable this API, though it will be on by default in the future.

[See the API reference for more information.](https://developers.cloudflare.com/workers/runtime-apis/context/#exports)
