---
title: Error 410 · Cloudflare Support docs
description: >-
  When a resource is intentionally and permanently removed, servers use the 410
  Gone status code to inform clients that the resource is no longer available.

  In this case:
lastUpdated: 2025-05-21T17:09:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-410/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-410/index.md
---

## 410 Gone

When a resource is intentionally and permanently removed, servers use the `410 Gone` status code to inform clients that the resource is no longer available. In this case:

* The server suggests that links referencing the resource should be removed.
* The server is not obligated to use this status code instead of a `404` response, nor is it required to maintain this response for any specific period of time.

For more details, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

This status is commonly applied to deprecated content, such as outdated pages or discontinued products.

### Cloudflare-specific information

Cloudflare does not generate `410` for customer websites, we only proxy the request from the origin server. If you encounter a `410` error on a Cloudflare-powered site, the issue lies with the origin server. In such cases, contact your hosting provider for assistance.
